/*
 *  * Memory Harness with Wishbone Slave interface
 *   */

module flash (
   flash_addr, flash_data, flash_oen,
   flash_wen,  flash_cen,  flash_clk,
   flash_adv, flash_rst
  );

// System inputs
  input         flash_clk;     // System Clock
  input         flash_rst;     // System Reset
  input         flash_adv;     // ??????????? 

// inputs

   input [21:0] flash_addr;
   input flash_oen;
   input flash_cen;
   input flash_wen;

//dibir
   inout reg [15:0] flash_data;

// Parameters
   parameter     addr_bits = 22;
   parameter     addr_max = (1<<addr_bits)-1;
   parameter     memfilename = "memory_hello.hex";
   parameter     memdefaultcontent = 16'h0000;

// Wires
   reg[15:0]     mem[addr_max:0];       // This is the memory!
   integer       i;                     // Index
   reg[15:0]     data;    
   
`ifdef DEBUG
  initial begin
    $display("INFO: MEMH %m: FLASH Memory Harness starting...");
    $display("INFO: MEMH %m: %0d Address Bits / %0d Doublewords / %0d Bytes Total Memory", addr_bits, addr_max+1, (addr_max+1)*8);
    for(i=0; i<=addr_max; i=i+1) mem[i] = memdefaultcontent;
    $readmemh(memfilename, mem);
    $display("INFO: MEMH %m: Memory initialization completed");
    //for(i=0; i<=1023; i=i+1) $display("mem_i = %x",mem[i]) ;
  end
`endif

assign flash_data = !flash_oen ? data :16'hzzzz;

always @(posedge flash_clk) begin
    // Read cycle
 if (!flash_oen & flash_wen) 
        begin
                //$display("INFO: flash: read from address %x data %x",flash_addr, mem[flash_addr]);
        	data <= mem[flash_addr];
	end
    else // Write cycle
      if (flash_oen & !flash_wen) 
		$display("INFO: flash: write to address %x data %x (now disabled)",flash_addr,flash_data);
                //mem[flash_addr] <= flash_data; FIXME: errouneous spourious writes in flash
      end
endmodule
   
