#start with: vsim -c -do simula.do

set DEFINE +define+DEBUG+FPGA_SYN
#+FPGA_SYN_NO_SPU
#+FPGA_NEW_IRF
set INCLUDEDIR +incdir+../T1-common/include/
vlib work

#Map the required libraries here.#

#Compile all modules#

vlog  $DEFINE $INCLUDEDIR ../T1-common/common/*.v
vlog  $DEFINE $INCLUDEDIR  ../Top/*.v
vlog  $DEFINE +incdir+../OC-UART $INCLUDEDIR ../OC-UART/*.v
vlog  $DEFINE $INCLUDEDIR ../NOR-flash/*.v
vlog  $DEFINE $INCLUDEDIR ../os2wb/*.v
vlog  $DEFINE $INCLUDEDIR ../T1-common/m1/*.V
vlog  $DEFINE $INCLUDEDIR ../T1-common/srams/*.v
vlog  $DEFINE $INCLUDEDIR ../T1-common/u1/*.V
vlog  $DEFINE $INCLUDEDIR/ ../T1-FPU/*.v
vlog  $DEFINE $INCLUDEDIR +incdir+../WB ../WB/*.v
vlog  $DEFINE $INCLUDEDIR ../WB2ALTDDR3/*.v
vlog  $DEFINE $INCLUDEDIR ../Xilinx/*.v
vlog  $DEFINE $INCLUDEDIR ../T1-CPU/exu/*.v
vlog  $DEFINE $INCLUDEDIR ../T1-CPU/ffu/*.v
vlog  $DEFINE $INCLUDEDIR ../T1-CPU/ifu/*.v
vlog  $DEFINE $INCLUDEDIR ../T1-CPU/lsu/*.v
vlog  $DEFINE $INCLUDEDIR ../T1-CPU/mul/*.v
vlog  $DEFINE $INCLUDEDIR ../T1-CPU/rtl/*.v
vlog  $DEFINE $INCLUDEDIR ../T1-CPU/spu/*.v
vlog  $DEFINE $INCLUDEDIR ../T1-CPU/tlu/*.v

#Compile files in sim folder (excluding model parameter file)#
#$XILINX variable must be set
vlog  $env(XILINX)/../../verilog/src/glbl.v
#vlog  $XILINX/../../verilog/src/glbl.v
vlog  +define+DEBUG ../sim/*.v

#Pass the parameters for memory model parameter file#
vlog  +incdir+. +define+x512Mb +define+sg37E +define+x16 ddr2_model.v

#Load the design. Use required libraries.#


vsim -t ps -novopt +notimingchecks -L unisims_ver -L XilinxCoreLib work.tb_top glbl

#vsim -c -t ps -novopt +notimingchecks -L unisims_ver -L XilinxCoreLib work.tb_top glbl
#vsim -c -t ps -novopt +notimingchecks work.tb_top glbl

#add wave sim:/tb_top/W1_inst/dram_wb_inst/*
#exit
#pause
onerror {resume}
#Log all the objects in design. These will appear in .wlf file#
log -r /*
run -all
exit

#View sim_tb_top signals in waveform#
#add wave sim:/tb_top/*

#Change radix to Hexadecimal#
radix hex
#Supress Numeric Std package and Arith package warnings.#
#For VHDL designs we get some warnings due to unknown values on some signals at startup#
# ** Warning: NUMERIC_STD.TO_INTEGER: metavalue detected, returning 0#
#We may also get some Arithmetic packeage warnings because of unknown values on#
#some of the signals that are used in an Arithmetic operation.#
#In order to suppress these warnings, we use following two commands#
set NumericStdNoWarnings 1
set StdArithNoWarnings 1

#Choose simulation run time by inserting a breakpoint and then run for specified #
#period. For more details, refer to Simulation Guide section of MIG user guide (UG086).#
when {/sim_tb_top/phy_init_done = 1} {
if {[when -label a_100] == ""} {
when -label a_100 { $now = 50 us } {
nowhen a_100
report simulator control
report simulator state
if {[examine /sim_tb_top/error] == 0} {
echo "TEST PASSED"
stop
}
if {[examine /sim_tb_top/error] != 0} {
echo "TEST FAILED: DATA ERROR"
stop
}
}
}
}

#In case calibration fails to complete, choose the run time and then stop#
when {$now = @500 us and /sim_tb_top/phy_init_done != 1} {
echo "TEST FAILED: CALIBRATION DID NOT COMPLETE"
stop
}

echo "NOTE: Initial 200us power on period is skipped for simulation.
      Change SIM_ONLY parameter in sim_tb_top file to activate this."

run -all
stop

