#include "uart.h"

#define BASE_UART 0x800000FFF0C2C000 
#define BAUD_UART 100000 
//const long UART_BASE_ADR[1] = {0x800000FFF0C2C000};
//const int UART_BAUDS[1] = {0};
const int BAUD_RATE =100000;
const int IN_CLK =50000000;

#define REG8(add) *((volatile unsigned char *)(add))

#define BOTH_EMPTY (UART_LSR_TEMT | UART_LSR_THRE)

#define WAIT_FOR_XMITR(core)			\
do { \
lsr = REG8(BASE_UART + UART_LSR); \
} while ((lsr & BOTH_EMPTY) != BOTH_EMPTY)

#define WAIT_FOR_THRE(core)			\
do { \
lsr = REG8(BASE_UART + UART_LSR); \
} while ((lsr & UART_LSR_THRE) != UART_LSR_THRE)

#define CHECK_FOR_CHAR(core) (REG8(BASE_UART + UART_LSR) & UART_LSR_DR)

#define WAIT_FOR_CHAR(core)			\
do { \
lsr = REG8(BASE_UART + UART_LSR); \
} while ((lsr & UART_LSR_DR) != UART_LSR_DR)

#define UART_TX_BUFF_LEN 32
#define UART_TX_BUFF_MASK (UART_TX_BUFF_LEN -1)

char tx_buff[UART_TX_BUFF_LEN];
volatile int tx_level, rx_level;

void sal_main() __attribute__((noreturn));
void sal_main() 
{


/*
  #define CONFIG_SYS_GBL_DATA_SIZE       128     / size in bytes reserved for  initial data 
  #define CONFIG_SYS_GBL_DATA_OFFSET     (CONFIG_SYS_INIT_RAM_END - CONFIG_SYS_GBL_DATA_SIZE)
  #define CONFIG_SYS_INIT_SP_OFFSET      CONFIG_SYS_GBL_DATA_OFFSET


stackp:
	        set     CONFIG_SYS_INIT_SP_OFFSET, %fp
	        andn    %fp, 0x0f, %fp
	        sub     %fp, 64, %sp
*/
	uart_init(0);

	for(;;) { 
		uart_puts(0,"XOpenSparc is alive \n"); 
	} 
        //return;
}

void uart_init(char core)
{
	long allone=0xffffffffffffffff;
	int divisor;
	//float float_divisor;
	/* Reset receiver and transmiter */
	asm("nop \n");	
	asm("nop \n");	
	asm("nop \n");	
	asm("nop \n");
	REG8( BASE_UART + UART_FCR ) = UART_FCR_ENABLE_FIFO | UART_FCR_CLEAR_RCVR | UART_FCR_CLEAR_XMIT | UART_FCR_TRIGGER_14;
	//REG8( UART_BASE_ADR[core] + UART_FCR ) = UART_FCR_ENABLE_FIFO | UART_FCR_CLEAR_RCVR | UART_FCR_CLEAR_XMIT | UART_FCR_TRIGGER_14;
	asm("nop \n");	
	asm("nop \n");	
	asm("nop \n");	
	asm("nop \n");	
	asm("nop \n");	
	//asm("sethi %hi(8), %sp \n");	
	//asm("mov 0xfff, %sp \n");	

	/* Disable all interrupts */
	REG8(BASE_UART + UART_IER) = 0x00;
	//REG8(UART_BASE_ADR[core] + UART_IER) = 0x00;
	
	/* Set 8 bit char, 1 stop bit, no parity */
	REG8(BASE_UART + UART_LCR) = UART_LCR_WLEN8 & ~(UART_LCR_STOP | UART_LCR_PARITY);
	
	/* Set baud rate */
	//float_divisor = (float) IN_CLK/(16 * UART_BAUDS[core]);
	//float_divisor += 0.50f; // Ensure round up
	//divisor = (int) float_divisor;
	divisor = BAUD_RATE;

	REG8(BASE_UART + UART_LCR) |= UART_LCR_DLAB;
	REG8(BASE_UART + UART_DLL) = divisor & 0x000000ff;
	REG8(BASE_UART + UART_DLM) = (divisor >> 8) & 0x000000ff;
	REG8(BASE_UART + UART_LCR) &= ~(UART_LCR_DLAB);
	
	return;
}

void uart_putc(char core, char c)
{
	unsigned char lsr;
	
	WAIT_FOR_THRE(core);
	REG8(BASE_UART + UART_TX) = c;
	if(c == '\n') {
		WAIT_FOR_THRE(core);
		REG8(BASE_UART + UART_TX) = '\r';
	}
	WAIT_FOR_XMITR(core);
}

void uart_puts (char core, char *s) { 
	// loop until *s != NULL 
	while (*s) { 
		uart_putc(core,*s); 
		s++; 
	} 
}



// Only used when we know THRE is empty, typically in interrupt
/*void uart_putc_noblock(char core, char c)
{
	REG8(UART_BASE_ADR[core] + UART_TX) = c;
}


char uart_getc(char core)
{
	unsigned char lsr;
	char c;
	
	WAIT_FOR_CHAR(core);
	c = REG8(UART_BASE_ADR[core] + UART_RX);
	return c;
}

int uart_check_for_char(char core)
{
	return CHECK_FOR_CHAR(core);
}

void uart_rxint_enable(char core)
{
	REG8(UART_BASE_ADR[core] + UART_IER) |= UART_IER_RDI;
}

void uart_rxint_disable(char core)
{
	REG8(UART_BASE_ADR[core] + UART_IER) &= ~(UART_IER_RDI);
}

void uart_txint_enable(char core)
{
	REG8(UART_BASE_ADR[core] + UART_IER) |= UART_IER_THRI;
}

void uart_txint_disable(char core)
{
	REG8(UART_BASE_ADR[core] + UART_IER) &= ~(UART_IER_THRI);
}

char uart_get_iir(char core)
{
	return REG8(UART_BASE_ADR[core] + UART_IIR);
}


char uart_get_lsr(char core)
{
	return REG8(UART_BASE_ADR[core] + UART_LSR);
}


char uart_get_msr(char core)
{
	return REG8(UART_BASE_ADR[core] + UART_MSR);
}
*/


